function [dairyMS, sheepSR, ForestAge, ScrubAge, LURNZDATA, c, GISheader, coef, lookup_tables] = GHGM1_load_data(output_path, ALL_YEARS)
%
% Greenhouse Gas Module - function 1 (GHGM1)
%
% This file loads the maps from the intensity module from which we
% calcualte greenhouse gas emissions.

% Code by Simon Anastasiadis : 2012-04-05

%% Parameters

% path for data
load_path2 = '..\Data for Modules\Data 2 Land Use Allocation Module';
load_path3 = '..\Data for Modules\Data 3 Land Use Intensity Module';
load_path4 = '..\Data for Modules\Data 4 Greenhouse Gas Module';
% path for land use allocations
LUAM_path = [output_path, '\Results 2 Land Use Allocation Module'];
% path for land use intensity
LUIM_path = [output_path, '\Results 3 Land Use Intensity Module'];

% We load coefficients provided by Levi Timar. These coefficients cover
% both the intensity and GHG modules. We have stored them in the intensity
% module data folder.
%
% info for loading agriculture coefficients
% coefficent file
coef_file_name = '\coefficients Timar 2013.xlsx';
% sheet names
dairy_sheet_name = 'dairy';
sheep_sheet_name = 'sheepbeef';
% dairy coefficient ranges
dairy_GHG_per_milksolid_range = 'D2:G2';
dairy_stock_per_ha_range  = 'C23:G39';
dairy_GHG_per_stock_range = 'D21:G21';
dairy_GHG_per_Nfertiliser_range = 'D40:G40';
dairy_Nfertiliser_per_milksolid_range = 'D41:G41';
dairy_scaling_coef_range = 'D42:G42';
% sheep/beef coefficient ranges
SB_sheep_SU_proportion_range = 'C3:G33';
SB_GHG_per_sheep_SU_range = 'D34:G34';
SB_GHG_per_beef_SU_range  = 'D35:G35';
SB_GHG_per_Nfertiliser_range = 'D38:G38';
SB_Nfertiliser_per_SU_range = 'D39:G39';
SB_scaling_coef_range = 'D36:G36';
% specified according to instructions in xlsread file (supporting code)
% call: "help xlsread" from Matlab prompt

%% Place holders for variables that will be loaded

LURNZDATA = [];
c = [];
GISheader = [];
lookup_tables = [];
GISINTENSITY = [];
dairyMS = [];
sheepSR = [];

%% Load Land Use Intensity Module Output

load([LUIM_path,'\LUIM_output_data'],'dairyMS');
load([LUIM_path,'\LUIM_output_data'],'sheepSR');

%% Load lookup tables

% load look up tables
lookup_tables.post89 = xlsread([load_path4,'\Sequestration tables.xls'],'post89','A2:K52');
lookup_tables.pre90  = xlsread([load_path4,'\Sequestration tables.xls'],'pre90','A2:K43');
% column 1 = age
% columns 2-10 = total pine sequestration by region
% column 11 = indigenous forest / scrub sequestration

% regions:
% Col  2 = Auckland = TA 1-15
% Col  3 = Waikato / Taupo = TA 16-21, 36
% Col  4 = Bay of Plenty = TA 22-27
% Col  5 = Gisborne = TA 28
% Col  6 = Hawkes Bay / Southern North Island = TA 29-35, 37-48
% Col  7 = Nelson / Marlborough = TA 51-54
% Col  8 = Canterbury / West oast = 55-66
% Col  9 = Otago = TA 68-71
% Col 10 = Southland = TA 72-75

%% Load Agriculture coefficients
% GIS data loading is complete, now load coeffcieints

% dairy coefficients
coef.dairy_GHG_per_milksolid   = xlsread([load_path3,coef_file_name],dairy_sheet_name,dairy_GHG_per_milksolid_range);
coef.dairy_stock_per_ha        = xlsread([load_path3,coef_file_name],dairy_sheet_name,dairy_stock_per_ha_range);
coef.dairy_GHG_per_stock       = xlsread([load_path3,coef_file_name],dairy_sheet_name,dairy_GHG_per_stock_range);
coef.dairy_GHG_per_Nfertiliser = xlsread([load_path3,coef_file_name],dairy_sheet_name,dairy_GHG_per_Nfertiliser_range);
coef.dairy_Nfertiliser_per_milksolid  = xlsread([load_path3,coef_file_name],dairy_sheet_name,dairy_Nfertiliser_per_milksolid_range);
coef.dairy_scaling_coef        = xlsread([load_path3,coef_file_name],dairy_sheet_name,dairy_scaling_coef_range);
% sheep/beef coefficients
coef.SB_sheep_SU_proportion = xlsread([load_path3,coef_file_name],sheep_sheet_name,SB_sheep_SU_proportion_range);
coef.SB_GHG_per_sheep_SU    = xlsread([load_path3,coef_file_name],sheep_sheet_name,SB_GHG_per_sheep_SU_range);
coef.SB_GHG_per_beef_SU     = xlsread([load_path3,coef_file_name],sheep_sheet_name,SB_GHG_per_beef_SU_range);
coef.SB_GHG_per_Nfertiliser = xlsread([load_path3,coef_file_name],sheep_sheet_name,SB_GHG_per_Nfertiliser_range);
coef.SB_Nfertiliser_per_SU  = xlsread([load_path3,coef_file_name],sheep_sheet_name,SB_Nfertiliser_per_SU_range);
coef.SB_scaling_coef        = xlsread([load_path3,coef_file_name],sheep_sheet_name,SB_scaling_coef_range);

%% Load LUCAS, SB-classes, LIC classes and GISheader

% We want LUCAS data
load([load_path2,'\LUAM_input_data_25ha.mat'],'LURNZDATA');
load([load_path2,'\LUAM_input_data_25ha.mat'],'c');
% keep only essentials
LURNZDATA = LURNZDATA(:,[c.sorter, c.ta, c.rc, c.LUCAS]);
clear('c')

% We want SB-classes and LIc-classes from LUIM
load([load_path3,'\LUIM_input_data_25ha.mat'],'GISINTENSITY');
load([load_path3,'\LUIM_input_data_25ha.mat'],'c');
% check consistency
msg = sprintf('ERROR in GHG1\nGISINTENSITY and LURNZDATA have different sorters');
assert(all(GISINTENSITY(:,c.sorter) == LURNZDATA(:,1)),msg);
% keep only essentials
LURNZDATA = [LURNZDATA, GISINTENSITY(:,[c.lic, c.sbclass])];
clear('c','GISINTENSITY');

% make new 'c'
c.sorter = 1;
c.ta = 2;
c.rc = 3;
c.LUCAS = 4;
c.lic = 5;
c.sbclass = 6;

% We want the GISheader
load([load_path2,'\LUAM_input_data_25ha.mat'],'GISheader');

%% Load Forest and Scrub Age Maps

% load forest ages for endogenous pixels
load([LUAM_path,'\LUAM_output_data.mat'],'ForestAge_endogenous');
load([LUAM_path,'\LUAM_output_data.mat'],'ScrubAge_endogenous');
% load vector for exogenous pixels
load([LUAM_path,'\LUAM_output_data.mat'],'LU_exogenous');

% Age_endogenous contains all years
% trim to last year is only last year wanted
if ALL_YEARS == 0
    ForestAge_endogenous = ForestAge_endogenous(:,[1,end]);
    ScrubAge_endogenous = ScrubAge_endogenous(:,[1,end]);
end

% combine
LU_exogenous(:,2:size(ForestAge_endogenous,2)) = -9999;
ForestAge = [ForestAge_endogenous ; LU_exogenous];
ScrubAge = [ScrubAge_endogenous ; LU_exogenous];
% sort
ForestAge = sortrows(ForestAge);
ScrubAge = sortrows(ScrubAge);

%% Inform User loading data is complete

msg = sprintf(' - - GHGM1 : loading data complete');
disp(msg)

end
